/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class PanelGrafico
extends JComponent {
    private int posicionX = 100;
    private int posicionY = 100;
    private int height = 200;
    private int width = 200;

    public PanelGrafico() {
        this.setSize(this.width, this.height);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.pintar(graphics);
    }

    private void pintar(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.height, this.width);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(0, 0, this.height, this.width);
        graphics.setColor(Color.RED);
        graphics.fillOval(this.posicionX - 5, this.posicionY - 5, 10, 10);
    }

    public void desplazarX(int n) {
        if (0 < this.posicionX + n && this.posicionX + n < this.width) {
            this.posicionX += n;
            this.repaint();
        }
    }

    public void desplazarY(int n) {
        if (0 < this.posicionY + n && this.posicionY + n < this.height) {
            this.posicionY += n;
            this.repaint();
        }
    }
}

