// MueveLaBola.java

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.Container;
import javax.swing.border.EmptyBorder;
import java.awt.BorderLayout;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;
/** MueveLaBola.java
    @author Bosco...
*/
public class MueveLaBola extends JFrame{
    private static final int deltaX = 8;
    private static final int deltaY = 8;
    private PanelGrafico panel;
    
    public MueveLaBola(){
        setTitle("Mueve la Bola");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        panel = new PanelGrafico();
        
        JPanel panelContenedor = (JPanel) getContentPane();
        
        panel.setBorder(new EmptyBorder(5,5,5,5));
        
        panelContenedor.add(panel);
        setSize(panel.getHeight()+20, panel.getWidth()+40);
        
        addKeyListener(new KeyListener(){
            public void keyTyped(KeyEvent e){
            }
            public void keyPressed(KeyEvent e){
                if(e.getKeyCode() == KeyEvent.VK_LEFT){
                    panel.desplazarX(-deltaX);
                }else if(e.getKeyCode() == KeyEvent.VK_RIGHT){
                    panel.desplazarX(deltaX);
                }else if(e.getKeyCode() == KeyEvent.VK_UP){
                    panel.desplazarY(-deltaY);
                }else if(e.getKeyCode() == KeyEvent.VK_DOWN){
                    panel.desplazarY(deltaY);
                }
            }
            public void keyReleased(KeyEvent e){
            }
        });
            
        //pack();
        setVisible(true);
    }
    
    public static void main(String[] args){
        MueveLaBola app = new MueveLaBola();
    }
    
}