// PanelGrafico.java

import javax.swing.JComponent;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Dimension;

/** clase PanelGrafico...
    donde se dibuja...
    @author Bosco...
*/
public class PanelGrafico extends JComponent{
    // poscin de la bola:
    private int posicionX;
    private int posicionY;
    
    // tamao del "canvas":
    private int height;
    private int width;
    
    /** constructor...
    */
    public PanelGrafico(){
        height = 200;
        width = 200;
        posicionX = 100;
        posicionY = 100;
        setSize(width,height);
    }
    
    // para que sirva pack()...
    public Dimension getPreferredSize(){
        return new Dimension(width, height);
    }
    
    public void paint(Graphics g){
        super.paint(g);
        pintar(g);
    }
    
    private void pintar(Graphics g){
        // fondo
        g.setColor(Color.WHITE);
        g.fillRect(0,0,height,width);
        // marco...
        g.setColor(Color.BLACK);
        g.drawRect(0,0,height,width);
        // pelota...
        g.setColor(Color.RED);
        g.fillOval(posicionX-5,posicionY-5,10,10);
    }
    
    public void desplazarX(int n){
        if(0<posicionX+n && posicionX+n<width){
            posicionX+=n;
            repaint();
        }
    }
    
    public void desplazarY(int n){
        if(0<posicionY+n && posicionY+n<height){
            posicionY+=n;
            repaint();
        }
    }
}